%------------------------------------------------------------------------------
% File     : CSR124^1 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Do Mary and Sue like Bill in 2009?
% Version  : Especial.
% English  : Mary likes Bill. During 2009 Sue likes Bill. Does it hold during 
%            year 2009 that Mary likes Bill and Sue likes Bill? 

% Refs     : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : ef_6.tq_SUMO_local [Ben10]

% Status   : Theorem
% Rating   : 0.08 v9.1.0, 0.12 v9.0.0, 0.08 v8.2.0, 0.09 v8.1.0, 0.08 v7.4.0, 0.11 v7.3.0, 0.10 v7.2.0, 0.12 v7.1.0, 0.14 v7.0.0, 0.12 v6.4.0, 0.14 v6.3.0, 0.17 v6.2.0, 0.00 v6.1.0, 0.50 v6.0.0, 0.00 v5.3.0, 0.25 v4.1.0
% Syntax   : Number of formulae    :   11 (   1 unt;   8 typ;   0 def)
%            Number of atoms       :    6 (   0 equ;   0 cnn)
%            Maximal formula atoms :    3 (   2 avg)
%            Number of connectives :   15 (   0   ~;   0   |;   1   &;  14   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   4 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    7 (   7 usr;   4 con; 0-2 aty)
%            Number of variables   :    0 (   0   ^;   0   !;   0   ?;   0   :)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted signature
thf(numbers,type,
    num: $tType ).

thf(holdsDuring_THFTYPE_IiooI,type,
    holdsDuring_THFTYPE_IiooI: $i > $o > $o ).

thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(lYearFn_THFTYPE_IiiI,type,
    lYearFn_THFTYPE_IiiI: $i > $i ).

thf(likes_THFTYPE_IiioI,type,
    likes_THFTYPE_IiioI: $i > $i > $o ).

thf(n2009_THFTYPE_i,type,
    n2009_THFTYPE_i: $i ).

%----The translated axioms
thf(ax,axiom,
    likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ).

thf(ax_001,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i ) ).

%----The translated conjecture
thf(con,conjecture,
    ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i )
    @ ( ( likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i )
      & ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i ) ) ) ).

%------------------------------------------------------------------------------
